/*!
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2022-05-25
 *
 */
#include "usb_config.h"
#include "usbh_hid.h"
#include "usb_user.h"

/*!
 * @brief       Main program
 *
 * @param       None
 *
 * @retval      int
 */
int main(void)
{
    USART_Config_T usartConfig;

    /** Configure USART */
    usartConfig.baudRate = 115200;
    usartConfig.wordLength = USART_WORD_LEN_8B;
    usartConfig.stopBits = USART_STOP_BIT_1;
    usartConfig.parity = USART_PARITY_NONE;
    usartConfig.mode = USART_MODE_TX_RX;
    usartConfig.hardwareFlow = USART_HARDWARE_FLOW_NONE;

    APM_BOARD_COMInit(COM1,&usartConfig);
    printf("start\r\n");
    
    APM_EVAL_LEDInit(LED1);
    
    USBH_HID_Init();

    while (1)
    {
        USBH_PollingProcess();
        APM_EVAL_LEDToggle(LED1);
    }
}
